% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/enter_object.r
\name{enter_object}
\alias{enter_object}
\title{Dive into a specific object "key"}
\usage{
enter_object(x, ...)
}
\arguments{
\item{x}{a tbl_json object}

\item{...}{path to filter}
}
\description{
JSON can contain nested objects, such as {"key1": {"key2": [1, 2, 3]}}. The
function enter_object() can be used to access the array nested under "key1"
and "key2". After using enter_object(), all further tidyjson calls happen
inside the referenced object (all other JSON data outside the object
is discarded). If the object doesn't exist for a given row / index, then that
data.frame row will be discarded.
}
\details{
This is useful when you want to limit your data to just information found in
a specific key. Use the ... to specific a sequence of keys that you want to
enter into. Keep in mind that any rows with JSON that do not contain the key
will be discarded by this function.
}
\examples{
library(magrittr)  # for \%>\%
c('{"name": "bob", "children": ["sally", "george"]}', '{"name": "anne"}') \%>\%
  spread_values(parent.name = jstring("name")) \%>\%
  enter_object("children") \%>\%
  gather_array \%>\%
  append_values_string("children")
}

