% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_ollama.R
\name{ollama_chat}
\alias{ollama_chat}
\title{Interact with local AI models via the Ollama API}
\usage{
ollama_chat(
  .llm,
  .model = "gemma2",
  .stream = FALSE,
  .seed = NULL,
  .json_schema = NULL,
  .temperature = NULL,
  .num_ctx = 2048,
  .num_predict = NULL,
  .top_k = NULL,
  .top_p = NULL,
  .min_p = NULL,
  .mirostat = NULL,
  .mirostat_eta = NULL,
  .mirostat_tau = NULL,
  .repeat_last_n = NULL,
  .repeat_penalty = NULL,
  .tfs_z = NULL,
  .stop = NULL,
  .ollama_server = "http://localhost:11434",
  .timeout = 120,
  .keep_alive = NULL,
  .dry_run = FALSE
)
}
\arguments{
\item{.llm}{An LLMMessage object containing the conversation history and system prompt.}

\item{.model}{Character string specifying the Ollama model to use (default: "gemma2")}

\item{.stream}{Logical; whether to stream the response (default: FALSE)}

\item{.seed}{Integer; seed for reproducible generation (default: NULL)}

\item{.json_schema}{A JSON schema object as R list to enforce the output structure (default: NULL)}

\item{.temperature}{Float between 0-2; controls randomness in responses (default: NULL)}

\item{.num_ctx}{Integer; sets the context window size (default: 2048)}

\item{.num_predict}{Integer; maximum number of tokens to predict (default: NULL)}

\item{.top_k}{Integer; controls diversity by limiting top tokens considered (default: NULL)}

\item{.top_p}{Float between 0-1; nucleus sampling threshold (default: NULL)}

\item{.min_p}{Float between 0-1; minimum probability threshold (default: NULL)}

\item{.mirostat}{Integer (0,1,2); enables Mirostat sampling algorithm (default: NULL)}

\item{.mirostat_eta}{Float; Mirostat learning rate (default: NULL)}

\item{.mirostat_tau}{Float; Mirostat target entropy (default: NULL)}

\item{.repeat_last_n}{Integer; tokens to look back for repetition (default: NULL)}

\item{.repeat_penalty}{Float; penalty for repeated tokens (default: NULL)}

\item{.tfs_z}{Float; tail free sampling parameter (default: NULL)}

\item{.stop}{Character; custom stop sequence(s) (default: NULL)}

\item{.ollama_server}{String; Ollama API endpoint (default: "http://localhost:11434")}

\item{.timeout}{Integer; API request timeout in seconds (default: 120)}

\item{.keep_alive}{Character; How long should the ollama model be kept in memory after request (default: NULL - 5 Minutes)}

\item{.dry_run}{Logical; if TRUE, returns request object without execution (default: FALSE)}
}
\value{
A new LLMMessage object containing the original messages plus the model's response
}
\description{
Interact with local AI models via the Ollama API
}
\details{
The function provides extensive control over the generation process through various parameters:
\itemize{
\item Temperature (0-2): Higher values increase creativity, lower values make responses more focused
\item Top-k/Top-p: Control diversity of generated text
\item Mirostat: Advanced sampling algorithm for maintaining consistent complexity
\item Repeat penalties: Prevent repetitive text
\item Context window: Control how much previous conversation is considered
}
}
\examples{
\dontrun{
llm_message("user", "Hello, how are you?")
response <- ollama_chat(llm, .model = "gemma2", .temperature = 0.7)

# With custom parameters
response <- ollama_chat(
  llm,
  .model = "llama2",
  .temperature = 0.8,
  .top_p = 0.9,
  .num_ctx = 4096
)
}

}
