% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hts_tst_pos.R
\name{hts_tst_pos}
\alias{hts_tst_pos}
\title{Subset Newly Identified HIV Positive Clients over a Particular Period}
\usage{
hts_tst_pos(data, from = NULL, to = NULL, states = NULL, facilities = NULL)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}
}
\value{
line-list of hts_tst_pos clients
}
\description{
Subset Newly Identified HIV Positive Clients over a Particular Period
}
\examples{
### Line-list of clients hts positives from 'Okun' and 'Abaji' states in first half of 2021
hts_pos <- hts_tst_pos(
recency_example,
state = c("Okun", "Abaji"),
from = "2021-01-01",
to = "2021-06-30"
)
}
