% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{hz_to_mel}
\alias{hz_to_mel}
\title{Hz to Mel}
\usage{
hz_to_mel(hz, htk = FALSE)
}
\arguments{
\item{hz}{Numeric values in Hz}

\item{htk}{Whether or not to use the HTK formula}
}
\value{
A numeric vector of Mel values
}
\description{
Convert Hz to Mel
}
\details{
This is a direct re-implementation of the \code{hz_to_mel}
function from the \href{https://librosa.org/}{librosa} library.

The default method is to use the method due to Slaney (1998), which
is linear below 1000Hz, and logarithmic above.

If \code{htk=TRUE}, the method from HTK, due to O'Shaughnessy (1987) is used.
}
\examples{
hz_to_mel(c(500, 1000, 2000, 3000))

}
\references{
McFee, B., C. Raffel, D. Liang, D. PW Ellis, M. McVicar, E. Battenberg,
and O. Nieto. librosa: Audio and music signal analysis in python.
In Proceedings of the 14th python in science conference, pp. 18-25.

O'Shaughnessy, D (1987). Speech communication: human and machine.
Addison-Wesley. p. 150. ISBN 978-0-201-16520-3.

Slaney, M. (1998) Auditory Toolbox: A MATLAB Toolbox for Auditory Modeling
Work. Technical Report, version 2, Interval Research Corporation.
}
