% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_data_matrix.R, R/nested_prcomp.R
\name{plot.nested_analysis}
\alias{plot.nested_analysis}
\alias{plot_nested_analysis}
\alias{biplot.nested_prcomp}
\title{Plot a nested analysis}
\usage{
\method{plot}{nested_analysis}(x, ..., main = "", nrow = NULL, ncol = NULL)

plot_nested_analysis(
  .x,
  .fun,
  ...,
  nrow = NULL,
  ncol = NULL,
  .model_column = .data$model,
  .output_column = NULL
)

\method{biplot}{nested_prcomp}(x, ..., nrow = NULL, ncol = NULL)
}
\arguments{
\item{x, .x}{A \link{nested_analysis} object (or subclass)}

\item{...}{Passed to the plot function. Tidy evaluation is supported, and arguments are evaluated
within a transposed version of x for each row.}

\item{main}{The plot title}

\item{nrow, ncol}{Force a number of rows or columns in the output}

\item{.fun}{A function that produces graphical output}

\item{.model_column}{The column containing the model}

\item{.output_column}{The column in which the output of the plot function should be placed}
}
\value{
the input, invisibly
}
\description{
Calls \link[graphics:plot.default]{plot} or another (base) plotting function on all models, arranging the output in subplots.
}
\examples{
nd <- nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
)

na <- nested_analysis(nd, vegan::rda, X = data)
plot(na)

}
