% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-labels.R
\name{label_geochem}
\alias{label_geochem}
\title{Geochem facet labelers}
\usage{
label_geochem(
  labels,
  units = character(0),
  default_units = NA_character_,
  geochem_facet = 1,
  renamers = c(`^d([0-9]+)([HCNOS])$` = "paste(delta ^ \\\\1, \\\\2)", `^210Pb$` =
    "paste({}^210, Pb)", `^Pb210$` = "paste({}^210, Pb)"),
  multi_line = TRUE
)
}
\arguments{
\item{labels}{A data.frame of facet label values}

\item{units}{A named list of values = unit}

\item{default_units}{The default units to apply}

\item{geochem_facet}{Which facet to apply formatting}

\item{renamers}{Search and replace operations to perform in the form
search = replace. Replace text can (should) contain backreferences,
and will be parsed as an expression (see \link[grDevices:plotmath]{plotmath}). Use
NULL to suppress renaming.}

\item{multi_line}{See \link[ggplot2:labellers]{label_parsed}}
}
\value{
A \code{\link[ggplot2:labeller]{ggplot2::labeller()}}
}
\description{
Geochem facet labelers
}
\examples{

library(ggplot2)

ggplot(alta_lake_geochem, aes(x = value, y = depth)) +
  geom_lineh() +
  geom_point() +
  scale_y_reverse() +
  facet_wrap(
    vars(param),
    labeller = purrr::partial(label_geochem, geochem_facet = "param"),
    nrow = 1,
    scales = "free_x"
  ) +
  labs(x = NULL, y = "Depth (cm)")

}
