% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_boxplot}
\alias{add_boxplot}
\title{Add boxplot}
\usage{
add_boxplot(
  plot,
  dodge_width = NULL,
  alpha = 0.3,
  saturation = 1,
  show_whiskers = TRUE,
  show_outliers = TRUE,
  box_width = 0.6,
  whiskers_width = 0.8,
  outlier.size = 0.5,
  coef = 1.5,
  outlier.shape = 19,
  outlier.alpha = 1,
  linewidth = 0.25,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults to \code{0.8}.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{saturation}{A \code{number} between \code{0} and \code{1} for the color saturation of an object. A value of \code{0} is completely desaturated (white), \code{1} is the original color.}

\item{show_whiskers}{Whether to show boxplot whiskers. Defaults to \code{TRUE}.}

\item{show_outliers}{Whether to show outliers. Defaults to \code{TRUE}.}

\item{box_width}{Width of the boxplot. Defaults to \code{0.6}.}

\item{whiskers_width}{Width of the whiskers. Defaults to \code{0.8}.}

\item{outlier.size}{Size of the outliers. Defaults to \code{0.5}.}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5.}

\item{outlier.shape}{Shape of the outliers. Defaults to \code{19}.}

\item{outlier.alpha}{Opacity of the outliers. Defaults to \code{1}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add boxplot
}
\examples{
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_boxplot()

# Changing arguments:
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_boxplot(show_whiskers = FALSE)

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_boxplot(show_outliers = FALSE)

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_boxplot(box_width = 0.2)

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_boxplot(whiskers_width = 0.2)

}
