% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_reference_lines}
\alias{add_reference_lines}
\title{Add reference lines}
\usage{
add_reference_lines(
  plot,
  x = NULL,
  y = NULL,
  linetype = "dashed",
  linewidth = 0.25,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{x}{Numeric values where the reference lines should meet the x axis. For example, \code{x = 4} or \code{x = c(2,3,4)}.}

\item{y}{Numeric values where the reference lines should meet the y axis. For example, \code{y = 4} or \code{y = c(2,3,4)}.}

\item{linetype}{Either an integer (0-6) or a name (0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 4 = dotdash, 5 = longdash, 6 = twodash).}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add reference lines
}
\examples{
animals \%>\%
  tidyplot(x = weight, y = speed) \%>\%
   add_reference_lines(x = 4000, y = c(100, 200)) \%>\%
   add_data_points()

animals \%>\%
  tidyplot(x = weight, y = speed) \%>\%
   add_reference_lines(x = 4000, y = c(100, 200), linetype = "dotdash") \%>\%
   add_data_points()

}
