% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{view_plot}
\alias{view_plot}
\title{View plot on screen}
\usage{
view_plot(plot, data = all_rows(), title = ggplot2::waiver(), ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{data}{The data to be displayed in this layer. There are three options:
\itemize{
\item If \code{all_rows()} (the default) the complete dataset is displayed.
\item A \code{function} to subset the plot data. See \code{filter_rows()} and friends.
\item A \code{data.frame} to override the plot data.
}}

\item{title}{Plot title.}

\item{...}{Arguments passed on to \code{print()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
View plot on screen
}
\details{
\itemize{
\item \code{view_plot()} supports data subsetting. See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#data-subsetting}{Advanced plotting}.
}
}
\examples{
# View intermediate stages on screen
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  add_data_points_beeswarm() \%>\%
  view_plot(title = "Before changing color scheme") \%>\%
  adjust_colors(colors_discrete_seaside) \%>\%
  view_plot(title = "After changing color scheme")

# View data subsets on screen
gene_expression \%>\%
  tidyplot(x = condition, y = expression, color = sample_type) \%>\%
  add_mean_dash() \%>\%
  add_sem_errorbar() \%>\%
  add_data_points_beeswarm() \%>\%
  view_plot(data = filter_rows(external_gene_name == "Apol6"),
    title = "Apol6") \%>\%
  view_plot(data = filter_rows(external_gene_name == "Bsn"),
    title = "Bsn")

}
