% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce-data.R
\name{coalesce_data}
\alias{coalesce_data}
\title{Coalesce Data}
\usage{
coalesce_data(x, coalesce = list(), quiet = FALSE)
}
\arguments{
\item{x}{A data frame.}

\item{coalesce}{A uniquely named list of character vectors where the names are the
new column names and the values are the names of the columns to coalesce.
If a single value is provided for a column it is treated as a regular expression.}

\item{quiet}{A flag specifying whether to provide messages.}
}
\value{
The original data frame with one or more columns coalesced into a
new column.
}
\description{
Coalesce values in multiple columns by finding the first non-missing
value at each position.
Coalesced columns are removed.
}
\details{
Coalescence is performed in the order
specified in the coalesce argument such that a column produced by
coalescence can be further coalesced.
}
\examples{
data <- data.frame(x = c(1, NA, NA), y = c(NA, 3, NA), z = c(7, 8, 9), a = c(4, 5, 6))
coalesce_data(data, list(b = c("x", "y")), quiet = TRUE)
coalesce_data(data, list(z = c("y", "x"), d = c("z", "a")))
}
\seealso{
\code{\link[dplyr:coalesce]{dplyr::coalesce()}}
}
