% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse-comments.R
\name{collapse_comments}
\alias{collapse_comments}
\title{Collapse Comments}
\usage{
collapse_comments(...)
}
\arguments{
\item{...}{objects to be collapsed into a string.}
}
\value{
A string of the collapsed comments.
}
\description{
Collapse comments coercing each element to a string (character scalar)
and then collapsing into a single string using the '. ' separator.
}
\examples{
collapse_comments("Saw fish", character(0), "Nice. .", NA_character_)

data <- data.frame(
  visit = c(1,1,2, 2), 
  fish = 1:4,
  comment = c("Sunny day.  ", "Skinny fish", "Lost boot", NA))

\dontrun{
data |>
  dplyr::group_by(visit) |>
  dplyr::summarise(comment = collapse_comments(comment)) |>
  dplyr::ungroup()
}
}
\seealso{
\code{\link[=unite_str]{unite_str()}}
}
