% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_gt_dapc.R
\name{autoplot.gt_dapc}
\alias{autoplot.gt_dapc}
\title{Autoplots for \code{gt_dapc} objects}
\usage{
\method{autoplot}{gt_dapc}(
  object,
  type = c("screeplot", "scores", "loadings", "components"),
  ld = NULL,
  group = NULL,
  n_col = 1,
  ...
)
}
\arguments{
\item{object}{an object of class \code{gt_dapc}}

\item{type}{the type of plot (one of "screeplot", "scores", "loadings", and
"components")}

\item{ld}{the principal components to be plotted: for scores, a pair of
values e.g. c(1,2); for \code{loadings} either one or more values.}

\item{group}{a vector of group memberships to order the individuals in
"components" plot. If NULL, the clusters used for the DAPC will be used.}

\item{n_col}{for \code{loadings} plots, if multiple LD axis are plotted, how many
columns should be used.}

\item{...}{not currently used.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{gt_dapc}, the following types of plots are available:
\itemize{
\item \code{screeplot}: a plot of the eigenvalues of the discriminant axes
\item \code{scores} a scatterplot of the scores of each individual on two discriminant
axes (defined by \code{ld})
\item \code{loadings} a plot of loadings of all loci for a discriminant axis
(chosen with \code{ld})
\item \code{components} a bar plot showing the probability of assignment to
each cluster
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are not
customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA and run DAPC
pca <- gt_pca_partialSVD(lobsters)
populations <- as.factor(lobsters$population)
dapc_res <- gt_dapc(pca, n_pca = 6, n_da = 2, pop = populations)

# Screeplot
autoplot(dapc_res, type = "screeplot")

# Scores plot
autoplot(dapc_res, type = "scores", ld = c(1, 2))

# Loadings plot
autoplot(dapc_res, type = "loadings", ld = 1)

# Components plot
autoplot(dapc_res, type = "components", group = populations)

}
