% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.lmerModLmerTest.r
\name{tidy_stats.lmerModLmerTest}
\alias{tidy_stats.lmerModLmerTest}
\title{Create a tidy stats data frame from an lmerModLmerTest object}
\usage{
\method{tidy_stats}{lmerModLmerTest}(model)
}
\arguments{
\item{model}{Output of lmerTest's \code{lmer()}.}
}
\description{
\code{tidy_stats.lmerModLmerTest} takes an lmerModLmerTest object and converts the object to a tidy stats data frame.
}
\examples{
\donttest{
  # Load packages
  library(lme4)
  library(lmerTest)

  # Conduct a linear mixed model
  model_lmerTest <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

  # Tidy stats
  tidy_stats(model_lmerTest)
}

}
