% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_data.r
\name{describe_data}
\alias{describe_data}
\title{Calculate common descriptive statistics}
\usage{
describe_data(data, ..., na.rm = TRUE, short = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{One or more unquoted column names from the data frame.}

\item{na.rm}{A boolean indicating whether missing values (including NaN)
should be excluded in calculating the descriptives? The default is TRUE.}

\item{short}{A boolean indicating whether only a subset of descriptives
should be reported? If set to \verb{TRUE``, only the N, M, and SD will be returned. The default is }FALSE`.}
}
\description{
\code{\link[=describe_data]{describe_data()}} returns a set of common descriptive statistics
(e.g., number of observations, mean, standard deviation) for one or more
numeric variables.
}
\details{
The data can be grouped using \code{\link[dplyr:group_by]{dplyr::group_by()}} so that
descriptives will be calculated for each group level.

Skew and kurtosis are based on the \code{\link[datawizard:skewness]{datawizard::skewness()}} and
\code{\link[datawizard:skewness]{datawizard::kurtosis()}} functions (Komsta & Novomestky, 2015).
}
\examples{
describe_data(quote_source, response)

describe_data(quote_source, response, na.rm = FALSE)

quote_source |>
  dplyr::group_by(source) |>
  describe_data(response)

quote_source |>
  dplyr::group_by(source) |>
  describe_data(response, short = TRUE)

}
