% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dummies.R
\name{get_dummies.}
\alias{get_dummies.}
\alias{dt_get_dummies}
\title{Convert character and factor columns to dummy variables}
\usage{
get_dummies.(
  .data,
  cols = c(is.character, is.factor),
  prefix = TRUE,
  prefix_sep = "_",
  drop_first = FALSE,
  dummify_na = TRUE
)

dt_get_dummies(
  .data,
  cols = c(is.character, is.factor),
  prefix = TRUE,
  prefix_sep = "_",
  drop_first = FALSE,
  dummify_na = TRUE
)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{cols}{A single column or a vector of unquoted columns to dummify.
Defaults to all character & factor columns using \code{c(is.character, is.factor)}.
\code{tidyselect} compatible.}

\item{prefix}{TRUE/FALSE - If TRUE, a prefix will be added to new column names}

\item{prefix_sep}{Separator for new column names}

\item{drop_first}{TRUE/FALSE - If TRUE, the first dummy column will be dropped}

\item{dummify_na}{TRUE/FALSE - If TRUE, NAs will also get dummy columns}
}
\description{
Convert character and factor columns to dummy variables
}
\examples{
test_df <- tidytable(
  col1 = c("a", "b", "c", NA),
  col2 = as.factor(c("a", "b", NA, "d")),
  var1 = rnorm(4,0,1))

# Automatically does all character/factor columns
test_df \%>\%
  get_dummies.()

# Can select one column
test_df \%>\%
  get_dummies.(col1)

# Can select one or multiple columns in a vector of unquoted column names
test_df \%>\%
  get_dummies.(c(col1, col2))

# Can drop certain columns using
test_df \%>\%
  get_dummies.(c(is.character, -col2))

test_df \%>\%
  get_dummies.(prefix_sep = ".", drop_first = TRUE)

test_df \%>\%
  get_dummies.(c(col1, col2), dummify_na = FALSE)
}
