% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_cols.}
\alias{bind_cols.}
\title{Bind data.tables by row and column}
\usage{
bind_cols.(..., .name_repair = "unique")
}
\arguments{
\item{...}{data.tables or data.frames to bind}

\item{.name_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}
}
\description{
Bind multiple data.tables into one row-wise or col-wise.
}
\examples{
# Binding data together by row
df1 <- data.table(x = 1:3, y = 10:12)
df2 <- data.table(x = 4:6, y = 13:15)

df1 \%>\%
  bind_rows(df2)

# Can pass a list of data.tables
df_list <- list(df1, df2)

bind_rows(df_list)

# Binding data together by column
df1 <- data.table(a = 1:3, b = 4:6)
df2 <- data.table(c = 7:9)

df1 \%>\%
  bind_cols(df2)

# Can pass a list of data frames
bind_cols(list(df1, df2))
}
\keyword{internal}
