% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.Spat.R
\name{autoplot.Spat}
\alias{autoplot.Spat}
\alias{autoplot.SpatRaster}
\alias{autoplot.SpatVector}
\title{Create a complete ggplot for Spat* objects}
\usage{
\method{autoplot}{SpatRaster}(object, ..., rgb = NULL, facets = NULL, nrow = NULL, ncol = 2)

\method{autoplot}{SpatVector}(object, ...)
}
\arguments{
\item{object}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{other arguments passed to \code{\link[=geom_spatraster]{geom_spatraster()}},
\code{\link[=geom_spatraster_rgb]{geom_spatraster_rgb()}} or \code{\link[=geom_spatvector]{geom_spatvector()}}.}

\item{rgb}{Logical. Should be plotted as a RGB image? If \code{NULL} (the default)
\code{\link[=autoplot.SpatRaster]{autoplot.SpatRaster()}} would try to guess.}

\item{facets}{Logical. Should facets be displayed? If \code{NULL} (the default)
\code{\link[=autoplot.SpatRaster]{autoplot.SpatRaster()}} would try to guess.}

\item{nrow, ncol}{Number of rows and columns on the facet.}
}
\value{
A ggplot2 layer
}
\description{
\code{autoplot()} uses ggplot2 to draw plots as the ones produced by
\code{\link[terra:plot]{terra::plot()}}/\code{\link[terra:plotRGB]{terra::plotRGB()}} in a single command.
}
\details{
Implementation of \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} function.
\subsection{SpatRaster}{

Uses \code{\link[=geom_spatraster]{geom_spatraster()}} or \code{\link[=geom_spatraster_rgb]{geom_spatraster_rgb()}}.
}

\subsection{SpatVector}{

Uses \code{\link[=geom_spatvector]{geom_spatvector()}}. Labels can be placed with \code{\link[=geom_spatvector_text]{geom_spatvector_text()}}
or \code{\link[=geom_spatvector_label]{geom_spatvector_label()}}
}
}

\examples{
\donttest{

file_path <- system.file("extdata/cyl_temp.tif", package = "tidyterra")

library(terra)
temp <- rast(file_path)

library(ggplot2)
autoplot(temp)


# With a tile

tile <- system.file("extdata/cyl_tile.tif", package = "tidyterra") \%>\%
  rast()

autoplot(tile)

#  With vectors
v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))
autoplot(v)

v \%>\% autoplot(aes(fill = cpro)) +
  geom_spatvector_text(aes(label = iso2)) +
  coord_sf(crs = 25829)
}
}
\seealso{
\code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}

Other ggplot2 utils:
\code{\link{fortify.Spat}},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()},
\code{\link{ggspatvector}},
\code{\link{stat_spat_coordinates}()}

Other ggplot2 methods:
\code{\link{fortify.Spat}}
}
\concept{ggplot2.methods}
\concept{ggplot2.utils}
