% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr-like.R
\name{append_object}
\alias{append_object}
\title{Appending in a pipe, never unlisting}
\usage{
append_object(x, .l, name = NULL)
}
\arguments{
\item{x}{Object to append. If the object is a list, then it is appended as-is, and not unlisted.}

\item{.l}{The list to append to.
Special case handling applies if .l does not exist: then an empty list is used.
This alleviates the need for an initial mylist <- list()}

\item{name}{Will be used as name of the object in the list}
}
\value{
The list .l with x appended
}
\description{
Append to a given list, while considering as a single object and not unlisting as base::append does.
Argument order is reversed compared to base::append to allow a different pattern of use in a pipe.
}
\examples{
library(magrittr)
results <- list(first=c(3,4), second=list(5,6))
list(7,8) \%>\%
  append_object(results, "third result") ->
results
# results has length 1, containing one list named "first"
}
