% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_dbp.R
\name{chemdose_dbp_once}
\alias{chemdose_dbp_once}
\title{Apply `chemdose_dbp`function within a data frame and output a data frame}
\usage{
chemdose_dbp_once(
  df,
  input_water = "defined_water",
  cl2 = 0,
  time = 0,
  treatment = "raw",
  cl_type = "chlorine",
  location = "plant"
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_once}}. The df may include a column named for the applied chlorine dose (cl2),
and a column for time.}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{cl2}{Applied chlorine dose (mg/L as Cl2). Model results are valid for doses between 1.51 and 33.55 mg/L.}

\item{time}{Reaction time (hours). Model results are valid for reaction times between 2 and 168 hours.}

\item{treatment}{Type of treatment applied to the water. Options include "raw" for no treatment (default),
"coag" for water that has been coagulated or softened, and "gac" for water that has been treated by granular activated carbon (GAC).
GAC treatment has also been used for estimating formation after membrane treatment with good results.}

\item{cl_type}{Type of chlorination applied, either "chlorine" (default) or "chloramine".}

\item{location}{Location for DBP formation, either in the "plant" (default), or in the distribution system, "ds".}
}
\value{
A data frame with predicted DBP concentrations.
}
\description{
DBP = disinfection byproduct
}
\details{
This function allows \code{\link{chemdose_dbp}} to be added to a piped data frame.
Its output is a data frame containing columns for TTHM, HAA5, and individual DBP species.
DBPs are estimated based on the applied chlorine dose, the reaction time, treatment type, chlorine type, and DBP formation location.

The data input comes from a `water` class column, as initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.

If the input data frame has a chlorine dose column (cl2) or time column (time), the function will use those columns. Note:
The function can only take cl2 and time inputs as EITHER a column or from the function arguments, not both.

tidywater functions cannot be added after this function because they require a `water` class input.

For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
for the option to use parallel processing and speed things up. To initialize parallel processing, use
`plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
`fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_dbp_once(input_water = "balanced_water", cl2 = 4, time = 8)

example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  mutate(
    cl2 = seq(2, 24, 2),
    time = 30
  ) \%>\%
  chemdose_dbp_once(input_water = "balanced_water")

example_df <- water_df \%>\%
  mutate(br = 80) \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  mutate(time = 8) \%>\%
  chemdose_dbp_once(
    input_water = "balanced_water", cl = 6, treatment = "coag",
    location = "ds", cl_type = "chloramine"
  )
\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_dbp_once(input_water = "balanced_water", cl2 = 4, time = 8)

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{chemdose_dbp}}
}
