% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pac_toc.R
\name{pac_toc_once}
\alias{pac_toc_once}
\title{Apply `pac_toc`function within a data frame and output a data frame}
\source{
See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}

CHO(2007)
}
\usage{
pac_toc_once(
  df,
  input_water = "defined_water",
  dose = 0,
  time = 0,
  type = "bituminous"
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_chain}}. The df may include columns named for the dose, time, and type}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{dose}{Applied PAC dose (mg/L). Model results are valid for doses concentrations between 5 and 30 mg/L.}

\item{time}{Contact time (minutes). Model results are valid for reaction times between 10 and 1440 minutes}

\item{type}{Type of PAC applied, either "bituminous", "lignite", "wood".}
}
\value{
A data frame with an updated DOC, TOC, and UV254 concentration.
}
\description{
PAC = powdered activated carbon
}
\details{
This function allows \code{\link{pac_toc}} to be added to a piped data frame.
Its output is a data frame containing a water with updated TOC, DOC, and UV254.

The data input comes from a `water` class column, as initialized in \code{\link{define_water}}.

If the input data frame has a dose, time or type column, the function will use those columns. Note:
The function can only take dose, time, and type inputs as EITHER a column or from the function arguments, not both.

tidywater functions cannot be added after this function because they require a `water` class input.

For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
for the option to use parallel processing and speed things up. To initialize parallel processing, use
`plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
`fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain("raw") \%>\%
  pac_toc_once(input_water = "raw", dose = 10, time = 20)

example_df <- water_df \%>\%
  define_water_chain("raw") \%>\%
  mutate(dose = seq(5, 60, 5), time = 30) \%>\%
  pac_toc_once(input_water = "raw")

example_df <- water_df \%>\%
  define_water_chain("raw") \%>\%
  mutate(time = 8) \%>\%
  pac_toc_once(
    input_water = "raw", dose = 6, type = "wood"
  )

# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain("raw") \%>\%
  pac_toc_once(input_water = "raw", dose = 4, time = 8)

# Optional: explicitly close multisession processing
plan(sequential)

}
\seealso{
\code{\link{pac_toc}}
}
