% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_check.R
\name{tw_check_search}
\alias{tw_check_search}
\title{Checks if an input is a search; if not, it tries to return a search}
\usage{
tw_check_search(
  search,
  type = "item",
  language = tidywikidatar::tw_get_language(),
  response_language = tidywikidatar::tw_get_language(),
  limit = 10,
  include_search = FALSE,
  wait = 0,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{search}{A string to be searched in Wikidata}

\item{type}{Defaults to "item". Either "item" or "property".}

\item{language}{Language to be used for the search. Can be set once per
session with \code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full
list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{response_language}{Language to be used for the returned labels and
descriptions. Corresponds to the \code{uselang} parameter of the MediaWiki API,
as described
\href{https://www.wikidata.org/w/api.php?action=help&modules=wbsearchentities}{in
the official documentation}. Can be set once per session with
\code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{all
available language codes}.}

\item{limit}{Maximum numbers of responses to be given.}

\item{include_search}{Logical, defaults to \code{FALSE}. If \code{TRUE}, the search is
returned as an additional column.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE.} Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Defaults to \code{FALSE}. If \code{TRUE}, overwrites cache.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
A data frame with three columns, \code{id}, \code{label}, and \code{description},
filtered by the above criteria. Four columns if \code{include_search} is set to
\code{TRUE}.
}
\description{
Mostly used as a convenience function inside other functions to have
consistent inputs.
}
\examples{
# The following two lines should give the same result.

tw_check_search("Sylvia Pankhurst")
tw_check_search(tw_search("Sylvia Pankhurst"))
}
