% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tigger.R
\docType{package}
\name{tigger}
\alias{tigger}
\alias{tigger-package}
\title{tigger}
\description{
Here we provide a \strong{T}ool for \strong{I}mmuno\strong{g}lobulin
\strong{G}enotype \strong{E}lucidation via
\strong{R}ep-Seq (TIgGER). TIgGER inferrs the set of Ig alleles carried by an
individual (including any novel alleles) and then uses this set of alleles to
correct the initial assignments given to sample sequences by existing tools.
}
\details{
Immunoglobulin Repertoire-Sequencing (Rep-Seq) data is currently the
subject of much study. A key step in analyzing these data involves assigning
the closest known V(D)J germline alleles to the (often somatically mutated)
sample sequences using a tool such as IMGT/HighV-QUEST. However, if the
sample utilizes alleles not in the germline database used for alignment, this
step will fail. Additionally, this alignment has an associated error rate of
~5 percent, notably among sequences carrying a large number of somatic
mutations. The purpose of TIgGER is to address these issues.
}
\section{Core tigger functions}{

\itemize{
  \item  \link{findNovelAlleles}:   Detect novel alleles
  \item  \link{plotNovel}:          Plot evidence of novel alleles
  \item  \link{inferGenotype}:      Infer an Ig genotype
  \item  \link{plotGenotype}:       A colorful genotype visualization
  \item  \link{genotypeFasta}:      Convert a genotype to sequences
  \item  \link{reassignAlleles}:    Correct allele calls
}
}

\section{Mutation-related functions}{

\itemize{
  \item  \link{getMutatedPositions}:      Find mutation locations
  \item  \link{getMutCount}:              Find distance from germline
  \item  \link{findUnmutatedCalls}:       Subset unmutated sequences
  \item  \link{getPopularMutationCount}:  Find most common sequence's
                                          mutation count
  \item  \link{insertPolymorphisms}:      Insert SNPs into a sequence
}
}

\section{Input and formatting}{

\itemize{
  \item  \link{readIgFasta}:        Read a fasta file of Ig sequences
  \item  \link{updateAlleleNames}:  Correct outdated allele names
  \item  \link{sortAlleles}:        Sort allele names intelligently
  \item  \link{cleanSeqs}:          Standardize sequence format
}
}
\references{
Gadala-Maria \emph{et al}. (2015) Automated analysis of
high-throughput B cell sequencing data reveals a high frequency of novel
immunoglobulin V gene segment alleles. \emph{PNAS}. 112(8):E862-70.
}

