% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{initializeDb}
\alias{initializeDb}
\title{Create and initialize a database}
\usage{
initializeDb(dbPath, datasetName, datasetSpecies = "", datasetSource = "",
  datasetPlatform = "", datasetDescription = "", datasetSaveLocation = "",
  datasetFigureFilename = "")
}
\arguments{
\item{dbPath}{Path to the database file to be created. Empty string}

\item{datasetName}{Name of the data set}

\item{datasetSpecies}{Optional data set metadata: species}

\item{datasetSource}{Optional data set metadata: source}

\item{datasetPlatform}{Optional data set metadata: platform}

\item{datasetDescription}{Optional data set metadata: description}

\item{datasetSaveLocation}{Optional data set metadata: save location}

\item{datasetFigureFilename}{Optional data set metadata: figure file name}
}
\value{
A database object db needed by other tigreBrowserWriter functions
}
\description{
Create and initialize a database
}
\examples{
\dontrun{
  # Create a real database to a file
  db <- initializeDb("/path/to/the/database.sqlite", "My Dataset")
  closeDb(db)
}

  # Create a temporary database to be deleted at the end
  db <- initializeDb("", "My Dataset")
  closeDb(db)
}

