% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-time_series_cv_plan.R
\name{plot_time_series_cv_plan}
\alias{plot_time_series_cv_plan}
\title{Visualize a Time Series Resample Plan}
\usage{
plot_time_series_cv_plan(
  .rset,
  .date_var,
  .value,
  ...,
  .smooth = FALSE,
  .title = "Time Series Cross Validation Plan"
)
}
\arguments{
\item{.rset}{A time series resample specification of of either \code{rolling_origin}
or \code{time_series_cv} class.}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{...}{Additional parameters passed to \code{\link[=plot_time_series]{plot_time_series()}}}

\item{.smooth}{Logical - Whether or not to include a trendline smoother.
Uses See \code{\link[=smooth_vec]{smooth_vec()}} to apply a LOESS smoother.}

\item{.title}{Title for the plot}
}
\description{
The \code{plot_time_series_cv_plan()} function provides a visualization
for a time series resample specification (\code{rset}) of either \code{rolling_origin}
or \code{time_series_cv} class.
}
\details{
\strong{Resample Set}

A resample set is an output of the \code{timetk::time_series_cv()} function or the
\code{rsample::rolling_origin()} function.
}
\examples{
library(tidyverse)
library(tidyquant)
library(rsample)
library(timetk)

FB_tbl <- FANG \%>\%
    filter(symbol == "FB") \%>\%
    select(symbol, date, adjusted)

resample_spec <- time_series_cv(
    FB_tbl,
    initial = 150, assess = 50, skip = 50,
    cumulative = FALSE,
    lag = 30,
    slice_limit = 6
)

resample_spec \%>\% tk_time_series_cv_plan()

resample_spec \%>\%
    plot_time_series_cv_plan(
        date, adjusted, # date variable and value variable
        # Additional arguments passed to plot_time_series(),
        .facet_ncol = 3,
        .line_alpha = 0.5,
        .interactive = FALSE
    )

}
\seealso{
\itemize{
\item \code{\link[=time_series_cv]{time_series_cv()}} and \code{\link[rsample:rolling_origin]{rsample::rolling_origin()}} - Functions used to create
time series resample specfications.
\item \code{\link[=plot_time_series_cv_plan]{plot_time_series_cv_plan()}} - The plotting function used for visualizing the
time series resample plan.
}
}
