% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_md.R
\name{to_md}
\alias{to_md}
\title{Write YAML and XML back to disk as (R)Markdown}
\usage{
to_md(yaml_xml_list, path = NULL, stylesheet_path = stylesheet())
}
\arguments{
\item{yaml_xml_list}{result from a call to \code{\link[=to_xml]{to_xml()}} and editing.}

\item{path}{path of the new file. Defaults to \code{NULL}, which will not write
any file, but will still produce the conversion and pass the output as
a character vector.}

\item{stylesheet_path}{path to the XSL stylesheet}
}
\value{
the converted document, invisibly.
}
\description{
Write YAML and XML back to disk as (R)Markdown
}
\details{
The stylesheet you use will decide whether lists
are built using "*" or "-" for instance. If you're keen to
keep your own Markdown style when using \code{\link[=to_md]{to_md()}} after
\code{\link[=to_xml]{to_xml()}}, you can tweak the XSL stylesheet a bit and provide
the path to your XSL stylesheet as argument.
}
\examples{
path <- system.file("extdata", "example1.md", package = "tinkr")
yaml_xml_list <- to_xml(path)
names(yaml_xml_list)
library("magrittr")
# transform level 3 headers into level 1 headers
body <- yaml_xml_list$body
body \%>\%
  xml2::xml_find_all(xpath = './/d1:heading',
                     xml2::xml_ns(.)) \%>\%
  .[xml2::xml_attr(., "level") == "3"] -> headers3
xml2::xml_set_attr(headers3, "level", 1)
yaml_xml_list$body <- body
# save back and have a look
newmd <- tempfile("newmd", fileext = ".md")
to_md(yaml_xml_list, newmd)
# file.edit("newmd.md")
file.remove(newmd)

}
