% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf.R
\name{YAML-metadata}
\alias{YAML-metadata}
\title{Customizing PDF document styles}
\description{
Using YAML metadata to customize PDF documents.
}
\details{
You can easily customize fonts and a few other style attributes of  
PDF documents (\code{tintPdf} and \code{tintBook}) with 
YAML metadata
}
\section{Changing the fonts}{


You can use the fonts from the default \code{tufte} styles by setting
\code{defaultfonts: true}

You can choose custom LaTeX font packages using \code{latexfonts}:
\preformatted{
latexfonts: "bera"
}
will use Bera Serif fonts. You can also specify multiple fonts
(for instance serif, sans-serif, and typewriter families)
\preformatted{
latexfonts:
  - "bera"
  - "FiraSans"
  - "FiraSansMono"
}
will use the Bera Serif font for regular text, Fira Sans Regular for
sans serif, and Fira Sans Mono for typewriter.

You can also pass options to the packages:
\preformatted{
latexfonts: 
  - package: newtxmath
    options: 
      - cmintegrals
      - cmbraces
  - package: ebgaramond-maths
  - package: nimbusmononarrow
}
will use EB Garamond, with matching maths fonts from the \code{newtxmath}
package, and Nimbus Mono Narrow for the typewriter font.

If you want to specify a sans-serif font for the main text, many
packages allow you to do this with options:
The default for tint is to use the equivalent of
\preformatted{
latexfonts:
  - package: roboto
    options: 
      - sfdefault
      - condensed
}
where \code{sfdefault} specifies that the default text font should be Roboto.
Other packages use different options, such as Lato, another sans-serif 
font, which you would specify as the main font like this:
\preformatted{
latexfonts:
  - package: lato
    options: default
}
}

\section{Link Color}{


Changing the link color

By default, tint uses a grayish-blue color for hyperlinks. If you want to
change this, you can use the YAML \code{linkcolor} variable either as a 
string with three numbers (red, green, and blue) separated by commas:
\preformatted{
linkcolor: "0.3,0.3,0.6"
}
which gives a subtler bluish-gray,
or as a list of three colors:
\preformatted{
linkcolor:
  - 0.5
  - 0.2
  - 0.5
}
which gives a mauve color.
}

\seealso{
\link{Custom-templates}
}
