% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{run_test_dir}
\alias{run_test_dir}
\alias{test_all}
\title{Run all tests in a directory}
\usage{
run_test_dir(dir = "inst/tinytest", pattern = "^test.*\\\\.[rR]",
  at_home = TRUE, verbose = getOption("tt.verbose", TRUE),
  color = getOption("tt.pr.color", TRUE), remove_side_effects = TRUE,
  lc_collate = getOption("tt.collate", NA))

test_all(pkgdir = "./", testdir = "inst/tinytest", ...)
}
\arguments{
\item{dir}{\code{[character]} path to directory}

\item{pattern}{\code{[character]} A regular expression that is used to find
scripts in \code{dir} containing tests (by default \code{.R} or \code{.r}
files starting with \code{test}).}

\item{at_home}{\code{[logical]} toggle local tests.}

\item{verbose}{\code{[logical]} toggle verbosity during execution}

\item{color}{\code{[logical]} toggle colorize output}

\item{remove_side_effects}{\code{[logical]} toggle remove user-defined side 
effects. Environment variables (\code{Sys.setenv()}) and options (\code{options()})
defined in a test file are reset before running the next test file (see details).}

\item{lc_collate}{\code{[character]} Locale setting used to sort the
test files into the order of execution. The default \code{NA} ensures
current locale is used. Set this e.g. to \code{"C"} to ensure bytewise
and more platform-independent sorting (see details).}

\item{pkgdir}{\code{[character]} scalar. Root directory of the package (i.e.
direcory where \code{DESCRIPTION} and \code{NAMESPACE} reside).}

\item{testdir}{\code{[character]} scalar. Subdirectory where test files are
stored.}

\item{...}{passed to \code{run_test_dir}.}
}
\value{
A \code{tinytests} object
}
\description{
\code{run\_test\_dir} runs all test files in a directory.

\code{test_all} is a convenience function for package development, that wraps
\code{run_test_dir}. By default, it runs all files starting with
\code{test} in \code{./inst/tinytest/}.  It is assumed that all functions to be
tested are loaded.
}
\section{Details}{


We cannot guarantee that files will be run in any particular
order accross all platforms, as it depends on the available collation charts
(a chart that determines how alphabets are sorted).  For this reason it is a
good idea to create test files that run independent of each other so their
order of execution does not matter. In tinytest, test files cannot share
variables. The default behavior of test runners furher discourages
interdependence by resetting environment variables and options that are set
in a test file after the file is executed. If an environment variable needs
to survive a single file, use \code{base::Sys.setenv()} explicitly.
Similarly, if an option setting needs to survive, use \code{base::options}
}

\examples{
# create a test file in tempdir
tests <- "
addOne <- function(x) x + 2

expect_true(addOne(0) > 0)
expect_equal(2, addOne(1))
"
testfile <- tempfile(pattern="test_", fileext=".R")
write(tests, testfile)

# extract testdir
testdir <- dirname(testfile)
# run all files starting with 'test' in testdir
out <- run_test_dir(testdir)
print(out)
dat <- as.data.frame(out)

}
\seealso{
Other test-files: \code{\link{build_install_test}},
  \code{\link{run_test_file}},
  \code{\link{summary.tinytests}},
  \code{\link{test_package}}
}
\concept{test-files}
