% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPriorData.R
\name{createPriorData}
\alias{createPriorData}
\title{Creates input data frame for construction of MAP prior}
\usage{
createPriorData(
  studyLabel = NULL,
  nTotal,
  treatmentEffectEstimate,
  standardError
)
}
\arguments{
\item{studyLabel}{An optional vector containing trial labels.}

\item{nTotal}{A vector containing total sample sizes.}

\item{treatmentEffectEstimate}{A vector containing treatment effect estimates.}

\item{standardError}{A vector containing standard errors of the effect estimates.}
}
\value{
A data frame containing data on the trials in the source population.
}
\description{
Assembling information from trials in the source population in a structured way (required as a pre-processing step for MAP prior creation).
}
\examples{
priorData <- createPriorData(
  nTotal = c(160, 240, 320),
  treatmentEffectEstimate = c(1.23, 1.40, 1.51),
  standardError = c(0.4, 0.36, 0.31)
)
}
\seealso{
\code{\link[RBesT:gMAP]{RBesT::gMAP}}, \code{\link[RBesT:automixfit]{RBesT::automixfit}}
}
