% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_coverage.R
\name{oc_coverage}
\alias{oc_coverage}
\title{Assessing coverage}
\usage{
oc_coverage(
  m,
  se,
  true_effect,
  weights = seq(0, 1, by = 0.01),
  map_prior,
  sigma,
  n_cores = 1,
  eval_strategy = "sequential"
)
}
\arguments{
\item{m}{Numerical vector of simulated effect estimates.}

\item{se}{Numerical vector of simulated standard errors (\code{m} and \code{se} need to have the same length).}

\item{true_effect}{Numerical value, representing the true treatment effect (usually the mean of the simulated \code{m}).}

\item{weights}{Vector of weights of the informative component of the MAP prior (defaults to \code{seq(0, 1, by = 0.01)}).}

\item{map_prior}{A MAP prior containing information about the trials in the source population, created using \code{RBesT}; a mixture of normal distributions is required.}

\item{sigma}{Standard deviation of the weakly informative component of the MAP prior, recommended to be the unit-information standard deviation.}

\item{n_cores}{Integer value, representing the number of cores to be used (defaults to 1); only applies if \code{eval_strategy} is not "sequential".}

\item{eval_strategy}{Character variable, representing the evaluation strategy, either "sequential", "multisession", or "multicore" (see documentation of \code{future::plan}, defaults to "sequential").}
}
\value{
A 2-dimensional array containing results on coverage.
}
\description{
Assessment of coverage of posterior intervals for a given weight and evidence level, using simulated data as input.
}
\examples{
set.seed(123)
n_sims <- 5 # small number for exemplary application 
sim_dat <- list(
  "m" = rnorm(n = n_sims, mean = 1.15, sd = 0.1),
  "se" = rnorm(n = n_sims, mean = 1.8, sd = 0.3)
)
results <- oc_coverage(
  m = sim_dat[["m"]],
  se = sim_dat[["se"]],
  true_effect = 1.15,
  weights = seq(0, 1, by = 0.01), 
  map_prior = load_tipmap_data("tipmapPrior.rds"), 
  sigma = 16.23
) 
print(results)
}
\seealso{
\code{\link{oc_pos}} and \code{\link{oc_bias}}.
}
