% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip_with_continuous}
\alias{tip_with_continuous}
\alias{tip_c}
\title{Tip a result with a continuous confounder.}
\usage{
tip_with_continuous(mean_diff = NULL, gamma = NULL, lb = NULL,
  ub = NULL)

tip_c(mean_diff = NULL, gamma = NULL, lb = NULL, ub = NULL)
}
\arguments{
\item{mean_diff}{estimated mean difference of the unmeasured confounder in the
exposed population and unexposed population}

\item{gamma}{estimated size of an unmeasured confounder}

\item{lb}{lower bound of your observed effect}

\item{ub}{upper bound of your observed effect}
}
\value{
Numeric. The size of an unmeasured confounder at the given parameters
that would tip the observed result.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{mean_diff}
\item \code{gamma}
}
}
\details{
\code{\link[=tip_c]{tip_c()}} is an alias for \code{\link[=tip_with_continuous]{tip_with_continuous()}}.
}
\examples{
#to output the size of an unmeasured confounder needed to tip analysis
tip_with_continuous(mean_diff = -2, lb = 1.2, ub = 1.5)


}
