% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calc_densities.R
\name{calc_densities}
\alias{calc_densities}
\title{Calculate densities}
\usage{
calc_densities(shp, var, total.area.km2 = NA, units = "km2", suffix = "",
  drop = TRUE)
}
\arguments{
\item{shp}{a shape object, i.e. a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}

\item{var}{name(s) of a qualtity variable name contained in the \code{map} data}

\item{total.area.km2}{total area size of \code{shp} in number of squared kilometers. If \code{NA}, and \code{unit="km2"}, then the polygon coordinates are assumed to be in meters.}

\item{units}{the units of the area sizes, either \code{"m2"} or \code{"km2"}. In other words, either \code{var/m2} or \code{var/km2} density values are calculated.}

\item{suffix}{character that is appended to the variable names. The resulting names are used as column names of the returned data.frame.}

\item{drop}{boolean that determines whether an one-column data-frame should be returned as a vector}
}
\value{
Vector or data.frame (depending on whether \code{length(var)==1} with density values. This can be appended directly to the shape file with \code{\link{append_data}} with \code{fixed.order=TRUE}.
}
\description{
Transpose quantitative variables to densitiy variables, which are often needed for choroplets. For example, the colors of a population density map should correspond population density counts rather than absolute population numbers.
}
\examples{
data(NLD_muni)

NLD_muni_pop_per_km2 <- calc_densities(NLD_muni, var = c("pop_men", "pop_women"), suffix = "_km2")
NLD_muni <- append_data(NLD_muni, NLD_muni_pop_per_km2, fixed=TRUE)

qtm(NLD_muni, fill=c("pop_men_km2", "pop_women_km2"), nrow=1)
}
\keyword{densities}

