% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_fill}
\alias{tm_borders}
\alias{tm_fill}
\alias{tm_polygons}
\title{Draw polygons}
\usage{
tm_fill(col = "grey85", alpha = NA, palette = NULL,
  convert2density = FALSE, area = NULL, n = 5, style = "pretty",
  breaks = NULL, labels = NULL, auto.palette.mapping = TRUE,
  contrast = 1, max.categories = 12, colorNA = "grey60",
  textNA = "Missing", text_separator = "to", text_less_than = "Less than",
  text_or_more = "or more", thres.poly = 1e-05, title = NA,
  legend.is.portrait = TRUE, legend.hist = FALSE, legend.hist.title = NA,
  legend.z = NA, legend.hist.z = NA)

tm_borders(col = "grey40", lwd = 1, lty = "solid", alpha = NA)

tm_polygons(col = "grey85", alpha = NA, border.col = "grey40",
  border.alpha = NA, ...)
}
\arguments{
\item{col}{either a single color value or the name of a data variable that is contained in \code{shp}. In the latter case, either the data variable contains color values, or values (numeric or categorical) that will be depicted by a color palette (see \code{palette}. In the latter case, a choropleth is drawn. For \code{tm_borders}, it is a single color value that specifies the border line color.}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{palette}{palette name. See \code{RColorBrewer::display.brewer.all()} for options. Use a \code{"-"} as prefix to reverse the palette. By default, \code{"RdYlGn"} is taken for numeric variables and \code{"Dark2"} for categorical variables.}

\item{convert2density}{boolean that determines whether \code{col} is converted to a density variable. Should be \code{TRUE} when \code{col} consists of absolute numbers. The area size is either approximated from the shape object, or given by the argument \code{area}.}

\item{area}{Name of the data variable that contains the area sizes in squared kilometer.}

\item{n}{preferred number of classes (in case \code{col} is a numeric variable)}

\item{style}{method to cut the color scale (in case \code{col} is a numeric variable): e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{color used for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{text_separator}{Character string to use to separate numbers in the legend (default: "to").}

\item{text_less_than}{Character string to use to translate "Less than" (which is the default).}

\item{text_or_more}{Character string to use to translate "or more" (which is the default).}

\item{thres.poly}{number that specifies the threshold at which polygons are taken into account. The number itself corresponds to the proportion of the area sizes of the polygons to the total polygon size.}

\item{title}{title of the legend element}

\item{legend.is.portrait}{logical that determines whether the legend is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.hist}{logical that determines whether a histogram is shown}

\item{legend.hist.title}{title for the histogram. By default, one title is used for both the histogram and the normal legend.}

\item{legend.z}{index value that determines the position of the legend element with respect to other legend elements. The legend elements are stacked according to their z values. The legend element with the lowest z value is placed on top.}

\item{legend.hist.z}{index value that determines the position of the histogram legend element}

\item{lwd}{border line width (see \code{\link[graphics:par]{par}})}

\item{lty}{border line type (see \code{\link[graphics:par]{par}})}

\item{border.col}{border line color}

\item{border.alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{...}{arguments passed to either \code{tm_fill} or \code{tm_borders}}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws the polygons. \code{tm_fill} fills the polygons. Either a fixed color is used, or a color palette is mapped to a data variable. By default, a divering color palette is used for numeric variables and a qualitative palette for categorical variables. \code{tm_borders} draws the borders of the polygons. \code{tm_polygons} fills the polygons and draws the polygon borders.
}
\examples{
data(World)
data(Europe)
data(NLD_muni)
data(NLD_prov)

# Constant fill
tm_shape(World) + tm_fill("darkolivegreen3") + tm_layout_World(title="A green World")

# Borders only
tm_shape(Europe) + tm_borders()

# Data variable containing colours values
Europe$isNLD <- ifelse(Europe$name=="Netherlands", "darkorange", "darkolivegreen3")
tm_shape(Europe) +
    tm_fill("isNLD") +
tm_layout("Find the Netherlands!")

# Numeric data variable
tm_shape(NLD_muni) +
    tm_fill(col="population", convert2density=TRUE, 
        style="kmeans", title="Population (per km2)", legend.hist=TRUE) +
    tm_borders("grey25", alpha=.5) + 
tm_shape(NLD_prov) +
    tm_borders("grey40", lwd=2) +
tm_layout_NLD_wide(bg.color="white", draw.frame = FALSE, legend.hist.bg.color="grey90")

tm_shape(Europe) +
    tm_polygons("gdp_cap_est", style="kmeans", textNA = "Non-European countries", 
        title="GDP per capita") +
    tm_text("iso_a3", size="AREA", root=4, scale=2) +
tm_layout_Europe()

tm_shape(World) +
    tm_polygons("pop_est_dens", style="kmeans", palette="YlOrRd", title="Population per km2") +
    tm_text("iso_a3", size="AREA", scale=1.5) +
tm_layout_World()

# Categorical data variable
tm_shape(World) +
    tm_polygons("income_grp", palette="-Blues", title="Income classification") +
    tm_text("iso_a3", size="AREA", scale=1.5) +
tm_layout_World()

tm_shape(NLD_prov) + 
    tm_fill("name") + 
tm_shape(NLD_muni) + 
    tm_borders() + 
tm_shape(NLD_prov) + 
    tm_borders(lwd=2) +
    tm_text("name", shadow=TRUE) +
tm_layout_NLD("Provinces and municipalities", legend.show=FALSE, bg.color="white")
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}
\keyword{choropleth}

