% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tm_layout.R
\name{tm_layout}
\alias{tm_layout}
\alias{tm_layout_Europe}
\alias{tm_layout_Europe_wide}
\alias{tm_layout_NLD}
\alias{tm_layout_NLD_wide}
\alias{tm_layout_World}
\alias{tm_layout_World_wide}
\title{Layout elements of cartographic maps}
\usage{
tm_layout(title = NA, scale = 1, title.size = 1.3, bg.color = NULL,
  draw.frame = TRUE, asp = NA, frame.lwd = 1, outer.margins = rep(0.02,
  4), inner.margins = rep(0.02, 4), outer.bg.color = NULL,
  legend.show = TRUE, legend.only = FALSE, legend.position = NULL,
  legend.width = 0.3, legend.height = 0.9, legend.hist.height = 0.3,
  legend.hist.width = legend.width, legend.title.size = 1.1,
  legend.text.size = 0.7, legend.hist.size = 0.7,
  legend.scientific = FALSE, legend.digits = NA, legend.frame = FALSE,
  legend.bg.color = NA, legend.bg.alpha = 1, legend.hist.bg.color = NA,
  legend.hist.bg.alpha = 1, title.snap.to.legend = FALSE,
  title.position = c("left", "top"), title.bg.color = NA,
  title.bg.alpha = 1, design.mode = FALSE)

tm_layout_World(title = NA, inner.margins = c(0, 0.05, 0.025, 0.01),
  legend.position = c("left", "bottom"), scale = 0.8, ...)

tm_layout_World_wide(title = NA, inner.margins = c(0, 0.2, 0.025, 0.01),
  legend.position = c("left", "bottom"), legend.width = 0.4, scale = 0.8,
  ...)

tm_layout_Europe(title = NA, title.position = c("left", "top"),
  legend.position = c("left", "top"), inner.margins = c(0, 0.1, 0, 0), ...)

tm_layout_Europe_wide(title = NA, title.position = c("left", "top"),
  legend.position = c("left", "top"), inner.margins = c(0, 0.25, 0, 0),
  legend.width = 0.4, legend.hist.width = 0.4, ...)

tm_layout_NLD(title = NA, draw.frame = FALSE, inner.margins = c(0.02, 0.2,
  0.06, 0.02), legend.position = c("left", "top"), legend.width = 0.4, ...)

tm_layout_NLD_wide(title = NA, draw.frame = FALSE, inner.margins = c(0.02,
  0.3, 0.06, 0.02), legend.position = c("left", "top"), legend.width = 0.5,
  legend.hist.width = 0.35, ...)
}
\arguments{
\item{title}{Title(s). By default, the name of the statistical variable of which the legend is drawn at the top (see \code{legend.config}) is used as a title.}

\item{scale}{numeric value that serves as the global scale parameter. All font sizes, bubble sizes, border widths, and line widths are controled by this value. Each of these elements can be scaled independantly with the \code{scale}, \code{lwd}, or \code{size} arguments provided by the \code{\link{tmap-element}s}.}

\item{title.size}{Relative size of the title}

\item{bg.color}{Background color. By default it is \code{"white"}. A recommended alternative for choropleths is light grey (e.g., \code{"grey85"}).}

\item{draw.frame}{Boolean that determines whether a frama is drawn.}

\item{asp}{Aspect ratio. The aspect ratio of the map (width/height). If \code{NA}, it is determined by the bounding box (see argument \code{bbox} of \code{\link{tm_shape}}), the \code{outer.margins}, and the \code{inner.margins}. If \code{0}, then the aspect ratio is adjusted to the aspect ratio of the device.}

\item{frame.lwd}{Width of the frame}

\item{outer.margins}{Relative margins between device and frame. Vector of four values specifying the bottom, left, top, and right margin. Values are between 0 and 1.}

\item{inner.margins}{Relative margins inside the frame. Vector of four values specifying the bottom, left, top, and right margin. Values are between 0 and 1.}

\item{outer.bg.color}{Background color outside the frame.}

\item{legend.show}{Logical that determines whether the legend is shown.}

\item{legend.only}{logical. Only draw the legend (without map)? Particularly useful for small multiples with a common legend.}

\item{legend.position}{Position of the legend. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "center" or "right" for the first value and "top", "center", or "bottom" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y value of the left bottom corner of the legend. By default, it is automatically placed in the corner with most space based on the (first) shape object.}

\item{legend.width}{width of the legend}

\item{legend.height}{maximum height of the legend.}

\item{legend.hist.height}{height of the histogram. This hight is initial. If the total legend is downscaled to \code{legend.height}, the histogram is downscaled as well.}

\item{legend.hist.width}{width of the histogram. By default, it is equal to the \code{legend.width}.}

\item{legend.title.size}{Relative font size for the legend title}

\item{legend.text.size}{Relative font size for the legend text elements}

\item{legend.hist.size}{Relative font size for the choropleth histogram}

\item{legend.scientific}{logical. Should the numeric legend labels be formatted scientific?}

\item{legend.digits}{Number of digits for the legend labels}

\item{legend.frame}{either a logical that determines whether the legend is placed inside a frame, or a color that directly specifies the frame border color.}

\item{legend.bg.color}{Background color of the legend. Use \code{TRUE} to match with the overall background color \code{bg.color}.}

\item{legend.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{legend.bg.color} is used (normally 1).}

\item{legend.hist.bg.color}{Background color of the histogram}

\item{legend.hist.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{legend.hist.bg.color} is used (normally 1).}

\item{title.snap.to.legend}{Logical that determines whether the title is part of the legend.}

\item{title.position}{Position of the title. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "center" or "right" for the first value and "top", "center", or "bottom" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y value of the left bottom corner of the legend. By default the title is placed on top of the legend (determined by \code{legend.position})}

\item{title.bg.color}{background color of the title. Use \code{TRUE} to match with the overall background color \code{bg.color}.}

\item{title.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{title.bg.color} is used (normally 1).}

\item{design.mode}{Logical that enables the design mode. If \code{TRUE}, inner and outer margins, legend position, aspect ratio are explicitely shown. Also, feedback text in the console is given.}

\item{...}{other arguments from \code{tm_layout}}
}
\description{
This element specifies layout options for the maps. The main function \code{tm_layout} can be seen as a general layout theme. The functions \code{tm_layout_World}, \code{tm_layout_Europe}, and \code{tm_layout_NLD} are layout themes specified for the world, Europe, and Netherlands maps (which are contained in this package). For each of these layout themes, there is also an extra wide variant, with more space for the legend. Tip: create a layout theme for your own map (see example below).
}
\examples{
data(World)

tm_shape(World) + 
    tm_fill("pop_est_dens", style="kmeans", title="Population density") + 
tm_layout_World("World Population", bg.color="lightblue")

# A custom layout wrapper for Africa
tm_layout_Africa <- function(title=NA,
							 inner.margins = c(.02, .25, .02, .02),
							 draw.frame = FALSE,
							 title.position=c("left", "bottom"), 
							 legend.position = c("left", "bottom"),
							 legend.width = 0.5,
							 bg.color = "lightskyblue2", ...) {
	args <- c(as.list(environment()), list(...))
	do.call("tm_layout", args)
}

Africa <- World[World$continent=="Africa", ]

qtm(Africa, fill="pop_est_dens", fill.style="kmeans", fill.title="Population density") + 
    tm_layout_Africa("Africa")
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

