% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers_aux.R
\name{tm_graticules}
\alias{tm_graticules}
\alias{tm_grid}
\title{Coordinate grid / graticule lines}
\usage{
tm_graticules(
  x = NA,
  y = NA,
  n.x = NA,
  n.y = NA,
  crs = 4326,
  labels.format = list(suffix = intToUtf8(176)),
  labels.cardinal = TRUE,
  ...
)

tm_grid(
  x = NA,
  y = NA,
  n.x = NA,
  n.y = NA,
  crs = NA,
  col = NA,
  lwd = 1,
  alpha = NA,
  labels.show = TRUE,
  labels.pos = c("left", "bottom"),
  labels.size = 0.6,
  labels.col = NA,
  labels.rot = c(0, 0),
  labels.format = list(big.mark = ","),
  labels.cardinal = FALSE,
  labels.margin.x = 0,
  labels.margin.y = 0,
  labels.space.x = NA,
  labels.space.y = NA,
  labels.inside_frame = FALSE,
  ticks = labels.show & !labels.inside_frame,
  lines = TRUE,
  ndiscr = 100,
  zindex = NA,
  group = NA,
  group.control = "none",
  ...
)
}
\arguments{
\item{x}{X coordinates for vertical grid lines. If \code{NA}, it is specified
with a pretty scale and \code{n.x}.}

\item{y}{Y coordinates for horizontal grid lines. If \code{NA}, it is specified
with a pretty scale and \code{n.y}.}

\item{n.x}{Preferred number of grid lines for the x axis. For the labels,
a \code{\link[=pretty]{pretty()}} sequence is used, so the number of actual labels may be different than \code{n.x}.}

\item{n.y}{Preferred number of grid lines for the y axis. For the labels, a
\code{\link[=pretty]{pretty()}} sequence is used, so the number of actual labels may be different than \code{n.y}.}

\item{crs}{Projection character. If specified, the grid lines are projected
accordingly. Many world maps are projected, but still have latitude longitude
(EPSG 4326) grid lines.}

\item{labels.format}{List of formatting options for the grid labels. Parameters are:
\describe{
\item{fun}{Function to specify the labels. It should take a numeric vector,
and should return a character vector of the same size.
By default it is not specified. If specified, the list items \code{scientific},
\code{format}, and \code{digits} (see below) are not used.}
\item{scientific}{Should the labels be formatted scientifically?
If so, square brackets are used, and the \code{format} of the numbers is \code{"g"}.
Otherwise, \code{format="f"}, and \code{text.separator}, \code{text.less.than}, and
\code{text.or.more} are used. Also, the numbers are automatically rounded to
millions or billions if applicable.}
\item{format}{By default, \code{"f"}, i.e. the standard notation \code{xxx.xxx}, is used.
If \code{scientific=TRUE} then \code{"g"}, which means that numbers are formatted scientifically,
i.e. \code{n.dddE+nn} if needed to save space.}
\item{digits}{Number of digits after the decimal point if \code{format="f"}, and
the number of significant digits otherwise.}
\item{...}{Other arguments passed on to \code{\link[=formatC]{formatC()}}}
}}

\item{labels.cardinal}{Add the four cardinal directions (N, E, S, W) to the labels,
instead of using negative coordinates for west and south (so it assumes that
the coordinates are positive in the north-east direction).}

\item{...}{Used to catch deprecated arguments from tmap v3.}

\item{col}{Color of the grid lines.}

\item{lwd}{Line width of the grid lines}

\item{alpha}{Alpha transparency of the grid lines. Number between 0 and 1.
By default, the alpha transparency of \code{col} is taken.}

\item{labels.show}{Show tick labels. Either one value for both \code{x} and \code{y} axis,
or a vector two: the first for \code{x} and latter for \code{y}.}

\item{labels.pos}{position of the labels. Vector of two: the horizontal
("left" or "right") and the vertical ("top" or "bottom") position.}

\item{labels.size}{Font size of the tick labels}

\item{labels.col}{Font color of the tick labels}

\item{labels.rot}{Rotation angles of the labels. Vector of two values: the
first is the rotation angle (in degrees) of the tick labels on the x axis
and the second is the rotation angle of the tick labels on the y axis.
Only \code{0}, \code{90}, \code{180}, and \code{270} are valid values.}

\item{labels.margin.x}{Margin between tick labels of x axis and the frame.
Note that when \code{labels.inside_frame = FALSE} and \code{ticks = TRUE},
the ticks will be adjusted accordingly.}

\item{labels.margin.y}{Margin between tick labels of y axis and the frame.
Note that when \code{labels.inside_frame = FALSE} and \code{ticks = TRUE},
the ticks will be adjusted accordingly.}

\item{labels.space.x}{Space that is used for the labels and ticks for the x-axis
when \code{labels.inside_frame = FALSE}. By default, it is determined automatically
using the widths and heights of the tick labels. The unit of this parameter is text line height.}

\item{labels.space.y}{Space that is used for the labels and ticks for the y-axis
when \code{labels.inside_frame = FALSE}. By default, it is determined automatically
using the widths and heights of the tick labels. The unit of this parameter is text line height.}

\item{labels.inside_frame}{Show labels inside the frame? By default \code{FALSE}.}

\item{ticks}{If \code{labels.inside_frame = FALSE}, should ticks can be drawn between the labels and the frame?
Either one value for both \code{x} and \code{y} axis, or a vector two: the first for \code{x} and latter for \code{y}.}

\item{lines}{If \code{labels.inside_frame = FALSE}, should grid lines can be drawn?}

\item{ndiscr}{Number of points to discretize a parallel or meridian
(only applicable for curved grid lines)}

\item{zindex}{zindex of the pane in view mode. By default, it is set to the
layer number plus 400. By default, the tmap layers will therefore be placed
in the custom panes \code{"tmap401"}, \code{"tmap402"}, etc., except for the base tile
layers, which are placed in the standard \code{"tile"}. This parameter determines
both the name of the pane and the z-index, which determines the pane order
from bottom to top. For instance, if \code{zindex} is set to 500,
the pane will be named \code{"tmap500"}.}

\item{group}{Name of the group to which this layer belongs.
This is only relevant in view mode, where layer groups can be
switched (see \code{group.control})}

\item{group.control}{In view mode, the group control determines how layer groups
can be switched on and off. Options: \code{"radio"} for radio buttons (meaning only one group can be shown),
\code{"check"} for check boxes (so multiple groups can be shown), and \code{"none"}
for no control (the group cannot be (de)selected).}
}
\description{
Draws horizontal and vertical lines according to a coordinate reference system (CRS). \code{tm_grid()} uses the CRS of the (master) shape object, and \code{tm_graticules()} uses latitude and longitude coordinates (EPSG 4326). It creates a \code{\link{tmap-element}} that draws coordinate grid lines. It serves as a
layer that can be drawn anywhere between other layers.
}
\examples{
\dontrun{
current.mode <- tmap_mode("plot")

tm_shape(NLD_muni) +
	tm_polygons() +
	tm_grid()

tm_shape(NLD_muni) +
	tm_polygons() +
	tm_grid(crs = 4326)

tm_shape(NLD_muni) +
	tm_polygons() +
	tm_grid(crs = 3035, labels.inside.frame = TRUE)

tm_shape(World) +
	tm_polygons() +
	tm_facets(by = "continent") +
	tm_grid(labels.inside.frame = TRUE)

tm_shape(NLD_muni) +
	tm_polygons() +
	tm_graticules()

tm_shape(NLD_muni) +
	tm_polygons() +
	tm_graticules(labels.pos = c("right", "top"))


data(NLD_muni, World)

tmap_arrange(
	qtm(NLD_muni) + tm_grid(),
	qtm(NLD_muni) + tm_graticules()
)

qtm(World, shape.crs = "+proj=robin", style = "natural") +
	tm_graticules(ticks = FALSE) +
	tm_layout(frame=FALSE)

tmap_mode(current.mode)
}
}
