% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_GPX.R
\name{read_GPX}
\alias{read_GPX}
\title{Read GPX file}
\usage{
read_GPX(file, layers = c("waypoints", "tracks", "routes", "track_points",
  "route_points"), as.sf = FALSE)
}
\arguments{
\item{file}{a GPX filename (including directory)}

\item{layers}{vector of GPX layers. Possible options are \code{"waypoints"}, \code{"tracks"}, \code{"routes"}, \code{"track_points"}, \code{"route_points"}. By dedault, all those layers are read.}

\item{as.sf}{should \code{sf} objects be returned?}
}
\value{
for each defiend layer, a shape is returned (only if the layer has any features). If only one layer is defined, the corresponding shape is returned. If more than one layer is defined, a list of shape objects, one for each layer, is returned.
}
\description{
Read a GPX file. By default, it reads all possible GPX layers, and only returns shapes for layers that have any features.
}
\examples{
\dontrun{
if (require(tmap)) {
### Demo to visualise the route of the Amstel Gold Race, a professional cycling race
	tmpdir <- tempdir()
	tmpfile <- tempfile()
	download.file("http://www.gpstracks.nl/routes-fiets/f-limburg-amstel-gold-race-2014.zip",
				  tmpfile, mode="wb")
	unzip(tmpfile, exdir=tmpdir)

	# read GPX file
	AGR <- read_GPX(file.path(tmpdir, "f-limburg-amstel-gold-race-2014.gpx"))

	# read OSM of Zuid-Limburg
	Limburg_OSM <- read_osm(AGR$tracks, ext=1.05)

	# change route part names
	levels(AGR$tracks$name) <- paste(c("First", "Second", "Third", "Final"), "loop")
	AGR$tracks_offset2 <- offset_line(AGR$tracks, offset=c(.0005,0,-.0005,-.001))

	tm_shape(Limburg_OSM) +
		tm_raster(saturation=.25) +
	tm_shape(AGR$tracks_offset2) +
		tm_lines(col = "name", lwd = 4, title.col="Amstel Gold Race", palette="Dark2") +
	tm_shape(AGR$waypoints) +
		tm_bubbles(size=.1, col="gold", border.col = "black") +
		tm_text("name", size = .75, bg.color="white", bg.alpha=.25, auto.placement = .25) +
	tm_legend(position=c("right", "top"), frame=TRUE, bg.color = "gold") +
	tm_view(basemaps = "Esri.WorldTopoMap")
}
}
}
