% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/evidencePlot.R
\name{evidencePlot}
\alias{evidencePlot}
\title{Create an evidence plot for a module}
\usage{
evidencePlot(l, m, mset = "all", scaled = TRUE, filter = FALSE,
  add = FALSE, legend = "topleft")
}
\arguments{
\item{l}{sorted list of HGNC gene identifiers}

\item{m}{character vector of modules for which the plot should be created}

\item{mset}{Which module set to use (see tmodUtest for details)}

\item{scaled}{if TRUE, the cumulative sums will be divided by the total sum (default)}

\item{filter}{if TRUE, genes not defined in the module set will be removed}

\item{add}{if TRUE, the plot will be added to the existing plot}

\item{legend}{position of the legend. If NULL, no legend will be drawn}
}
\description{
Create an evidence plot for a module
}
\details{
This function creates an evidence plot for a module, based on an
ordered list of genes. The plot shows the receiving operator
characteristic (ROC) curve and a rug below, which indicates the distribution of the
module genes in the sorted list.
}
\examples{
# artificially enriched list of genes
set.seed(123)
data(tmod)
bg <- tmod$GENES$ID
fg <- sample( c(tmod$MODULES2GENES[["LI.M127"]], bg[1:1000]))
l <- unique(c(fg, bg))
evidencePlot(l, "LI.M127")
evidencePlot(l, filter=tmod$GENES$ID, "LI.M127")
}
\seealso{
\code{\link{tmod-package}}, \code{\link{hgEnrichmentPlot}}
}

