% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtnorm.R
\name{rtnorm}
\alias{rtnorm}
\title{Random Generation for Truncated Univariate Normal}
\usage{
rtnorm(mean = mean, sd = sd, lower = lower, upper = upper, n = NULL)
}
\arguments{
\item{mean}{vector of means. The length is the number of observations.}

\item{sd}{standard deviation. Defaults to 1.}

\item{lower}{a scalar of lower bound for truncation, or a vector of 
lower bounds with the same length as \code{mean}.}

\item{upper}{a scalar of upper bound for truncation, or a vector of 
upper bounds with the same length as \code{mean}.}

\item{n}{number of random samples when \code{mean} is a scalar.}
}
\value{
Returns a vector of random numbers following the specified 
  truncated univariate normal distribution.
}
\description{
Draws from truncated univariate normal distribution within an interval.
}
\examples{
set.seed(1203)
x = rtnorm(mean=rep(1,1000), sd=2, lower=-2, upper=3)
summary(x)

# use the alternative form of input
set.seed(1203)
x = rtnorm(mean=1, sd=2, lower=-2, upper=3, n=1000)
summary(x)

}
