% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team.R
\name{bart_team_box}
\alias{bart_team_box}
\title{Get Team Box Stats}
\usage{
bart_team_box(year = current_season(), type = "all")
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{type}{Filters by game type; defaults to `all`.}
}
\value{
Returns a tibble of team box totals and per-game averages
}
\description{
Returns team box totals and per-game averages by game type back to 2008.
}
\details{
Columns ending in 'pg' indicate a per-game average. Unless specified by
`type=d1`, results include games against non-Division 1 opponents.

The `type` argument splits the results by game type, explained below:
\describe{ \item{all}{All games played.} \item{nc}{Non-conference games.}
\item{conf}{In-conference games.} \item{post}{Post-conference tournament
games.} \item{d1}{Games against D-1 teams only.} \item{nond1}{Games involving
one non-D1 team.} }
}
\examples{
\donttest{bart_team_box(type='conf')}
}
