% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGraphClusters.R
\name{computeGraphClustersAsGraphs}
\alias{computeGraphClustersAsGraphs}
\title{Creates list of graphs for each specified component.}
\usage{
computeGraphClustersAsGraphs(channel, communities, ids = NULL,
  componentids = NULL, allTables = NULL, test = FALSE, parallel = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}.}

\item{communities}{community object returned by \code{\link{computeGraphClusters}}.}

\item{ids}{integer vector with cluster integer ids (from \code{1} to \code{N}, where \code{N} is the number of clusters). 
At least one value for this or \code{componentids} must be specified.}

\item{componentids}{character vector with cluster component ids assigned during community 
generation with \code{\link{computeGraphClusters}}. These component ids are derived from 
one of the vertex name (likely first vertex when ordered alphabetically). At least one value 
for this or \code{ids} must be specified.}

\item{allTables}{pre-built information about existing tables.}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}

\item{parallel}{logical: enable parallel calls to Aster database. This option requires parallel 
backend enabled and registered (see in examples). Parallel execution requires ODBC \code{channel} 
obtained without explicit password: either with \code{\link{odbcConnect}(dsn)} or 
\code{\link{odbcDriverConnect}} calls, but not with \code{\link{odbcConnect}(dsn, user, password)}.}
}
\value{
list of \code{\link{network}} objects materializing specified clusters (communities) represented by 
  \code{communities} object.
}
\description{
Based on the decomposition specified by \code{communities} object (see \code{\link{computeGraphClusters}}) 
materiazlies produced clusters as graph objects from Aster graph tables.
}
\examples{
if(interactive()) {

# undirected graph
policeGraphUn = toaGraph("dallaspolice_officer_vertices", "dallaspolice_officer_edges_un", 
     directed = FALSE, key = "officer", source = "officer1", target = "officer2", 
     vertexAttrnames = c("offense_count"), edgeAttrnames = c("weight"))
     
communities = computeGraphClusters(conn, policeGraphUn, type="connected", 
                                   createMembership = TRUE, includeMembership = TRUE,
                                   distanceTableName = "public.shortestpathdistances",
                                   membershipTableName = "public.clustermembership")
                                   
# get first 5 largest connected components as graphs
cluster_graphs = computeGraphClustersAsGraphs(conn, communities = communities, ids = 1:5)

# visualize component 2
library(GGally)
ggnet2(cluster_graphs[[2]], node.label="vertex.names", node.size="offense_count", 
       node.color="color", legend.position="none")

}  
  
}

