% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-utils.R
\name{cal_template}
\alias{cal_template}
\title{Set template for a calendar}
\usage{
cal_template(
  cal,
  milestoneTitle = NULL,
  taskTitle = NULL,
  alldayTitle = NULL,
  ...
)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{milestoneTitle}{The milestone title (at left column) template function.}

\item{taskTitle}{The task title (at left column) template function.}

\item{alldayTitle}{The allday title (at left column) template function.}

\item{...}{Additionals arguments, see online documentation.}
}
\value{
A \code{calendar} htmlwidget object.
}
\description{
Template JS functions to support customer renderer
}
\note{
Online JavaScript documentation: \url{https://nhn.github.io/tui.calendar/latest/Template/}.
All arguments must be JavaScript function with \code{\link[htmlwidgets:JS]{htmlwidgets::JS()}}.
}
\examples{
calendar(view = "week", taskView = TRUE) \%>\%
  cal_template(
    milestoneTitle = "TODO",
    taskTitle = "Assignment",
    alldayTitle = "Full-time"
  )
}
