% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar}
\alias{calendar}
\title{Create an interactive calendar}
\usage{
calendar(
  data = NULL,
  view = c("month", "week", "day"),
  defaultDate = NULL,
  taskView = FALSE,
  scheduleView = TRUE,
  useDetailPopup = TRUE,
  useCreationPopup = FALSE,
  isReadOnly = TRUE,
  navigation = FALSE,
  navOpts = navigation_options(),
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} with schedules data, see \code{\link[=cal_demo_data]{cal_demo_data()}}.}

\item{view}{Default view of calendar. The default value is 'week',
other possible values are 'month' and 'day'.}

\item{defaultDate}{Default date for displaying calendar.}

\item{taskView}{Show the milestone and task in weekly, daily view.
The default value is \code{FALSE}. If the value is a vector, it can be \code{"milestone"}, \code{"task"}.}

\item{scheduleView}{Show the all day and time grid in weekly, daily view.
The default value is \code{TRUE}. If the value is a vector, it can be \code{"allday"}, \code{"time"}.}

\item{useDetailPopup}{Logical. Display a pop-up on click with detailed informations about schedules.}

\item{useCreationPopup}{Logical. Allow user to create schedules with a pop-up.}

\item{isReadOnly}{Calendar is read-only mode and a user can't create and modify any schedule. The default value is true.}

\item{navigation}{Add navigation buttons to got to previous or next period, or return to 'today'.}

\item{navOpts}{Options to customize buttons (only if \code{navigation = TRUE}), see \code{\link[=navigation_options]{navigation_options()}}.}

\item{...}{Additional arguments passed to JavaScript method.}

\item{width, height}{A numeric input in pixels.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Build interactive calendar with the JavaScript tui-calendar library.
}
\examples{

# Default: monthly view
calendar()

# Weekly view
calendar(view = "week")

# Or only day:
calendar(view = "day")

# Add navigation buttons
calendar(navigation = TRUE)

# Add schedules data
ex_data <- cal_demo_data()
calendar(ex_data)


# By default detail popup is activated
# you can click on a schedule to view detail
calendar(useDetailPopup = TRUE) \%>\%
  cal_schedules(
    title = "My schedule",
    body = "Some detail about it",
    start = format(Sys.Date(), "\%Y-\%m-03"),
    end = format(Sys.Date(), "\%Y-\%m-04"),
    category = "allday"
  )

# to disable it use useDetailPopup = FALSE

# You can use HTML tags inside it:
library(htmltools)
calendar(useDetailPopup = TRUE) \%>\%
  cal_schedules(
    title = "My schedule",
    body = doRenderTags(tags$div(
      tags$h3("Title for my schedule"),
      tags$p(
        "Yan can write", tags$em("custom"), tags$b("HTML"),
        "in a popup !"
      ),
      tags$p(
        style = "color: firebrick;",
        "For example write in red !"
      ),
      tags$ul(
        tags$li("Or make a bullet list!"),
        tags$li("With another item"),
        tags$li("And one more")
      )
    )),
    start = format(Sys.Date(), "\%Y-\%m-03"),
    end = format(Sys.Date(), "\%Y-\%m-04"),
    category = "allday"
  )
}
\seealso{
\code{\link[=calendarOutput]{calendarOutput()}} / \code{\link[=renderCalendar]{renderCalendar()}} for usage in Shiny applications.
}
