% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-editor.R
\name{validateOpts}
\alias{validateOpts}
\title{Validation options}
\usage{
validateOpts(
  required = NULL,
  type = NULL,
  min = NULL,
  max = NULL,
  regExp = NULL,
  unique = NULL,
  jsfun = NULL
)
}
\arguments{
\item{required}{If set to \code{TRUE}, the data of the column will be checked to be not empty.}

\item{type}{Type of data, can be \code{"string"} or \code{"number"}.}

\item{min}{For numeric values, the minimum acceptable value.}

\item{max}{For numeric values, the maximum acceptable value.}

\item{regExp}{A regular expression to validate content.}

\item{unique}{If set to \code{TRUE}, check the uniqueness on the data of the column.}

\item{jsfun}{A \code{JS} function to validate content.}
}
\value{
A \code{datagrid} htmlwidget.


}
\description{
Validate columns' content with rules, useful when content is editable.
}
\examples{


library(shiny)

ui <- fluidPage(
  tags$h2("Validation rules"),
  datagridOutput("grid"),
  verbatimTextOutput("validation")
)

server <- function(input, output, session) {

  output$grid <- renderDatagrid({
    validate <- data.frame(
      col_text = c("a", "b", "a", NA, "c"),
      col_number = sample(1:10, 5),
      col_mail = c("victor@mail.com", "victor", NA, "victor@mail", "victor.fr")
    )

    datagrid(validate) \%>\%
      grid_editor(
        "col_text", type = "text",
        validation = validateOpts(required = TRUE, unique = TRUE)
      ) \%>\%
      grid_editor(
        "col_number", type = "number",
        validation = validateOpts(min = 0, max = 5)
      ) \%>\%
      grid_editor(
        "col_mail", type = "text",
        validation = validateOpts(
          regExp = "^([a-zA-Z0-9_\\\\-\\\\.]+)@([a-zA-Z0-9_\\\\-\\\\.]+)\\\\.([a-zA-Z]{2,5})$"
        )
      )
  })

  output$validation <- renderPrint({
    input$grid_validation
  })

}

if (interactive())
  shinyApp(ui, server)
}
