% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{remove_items}
\alias{remove_items}
\alias{insert_items}
\alias{get_item}
\title{Modify a Toml object}
\usage{
remove_items(x, keys)

insert_items(x, ..., df_as_array = TRUE)

get_item(x, key)
}
\arguments{
\item{x}{an object of class \code{Toml}.}

\item{keys}{a character vector of key names to remove. Cannot contain missing values.}

\item{...}{named items to be serialized to TOML.}

\item{df_as_array}{default \code{TRUE}. Creates an array of tables from a \code{data.frame}.
When \code{FALSE}, creates a single table with an array for each column in the data.frame.}

\item{key}{a character vector of key values. The keys are used recursively. For example with \code{key = c("a", "b")} the item \code{a} is grabbed first, then \code{b} is searched for inside of \code{a}.}
}
\value{
an object of class \code{Toml}
}
\description{
\code{remove_items()} removes one or more items from the TOML document.
Alternatively, \code{insert_items()} inserts key value pairs into the TOML
document.
}
\examples{
x <- toml(
  date = list(
    full = as.Date("2025-02-07"),
    parts = list(year = 2015L, month = "February", day = 7L)
  ),
  season = "winter"
)

# fetch the date table
get_item(x, "date")

# fetch the month value
get_item(x, c("date", "parts", "month"))

# remove an item based on name
remove_items(x, "season")

# add multiple items
insert_items(x, temperature = 31, cloudy = TRUE)
}
