% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_cholesky_inverse}
\alias{torch_cholesky_inverse}
\title{Cholesky_inverse}
\arguments{
\item{input}{(Tensor) the input 2-D tensor \eqn{u}, a upper or lower triangular           Cholesky factor}

\item{upper}{(bool, optional) whether to return a lower (default) or upper triangular matrix}

\item{out}{(Tensor, optional) the output tensor for \code{inv}}
}
\description{
Cholesky_inverse
}
\section{cholesky_inverse(input, upper=False, out=None) -> Tensor }{


Computes the inverse of a symmetric positive-definite matrix \eqn{A} using its
Cholesky factor \eqn{u}: returns matrix \code{inv}. The inverse is computed using
LAPACK routines \code{dpotri} and \code{spotri} (and the corresponding MAGMA routines).

If \code{upper} is \code{False}, \eqn{u} is lower triangular
such that the returned tensor is

\deqn{
    inv = (uu^{{T}})^{{-1}}
}
If \code{upper} is \code{True} or not provided, \eqn{u} is upper
triangular such that the returned tensor is

\deqn{
    inv = (u^T u)^{{-1}}
}
}

\examples{
if (torch_is_installed()) {

\dontrun{
a = torch_randn(c(3, 3))
a = torch_mm(a, a$t()) + 1e-05 * torch_eye(3) # make symmetric positive definite
u = torch_cholesky(a)
a
torch_cholesky_inverse(u)
a$inverse()
}
}
}
