% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignite.R
\name{optim_ignite_sgd}
\alias{optim_ignite_sgd}
\title{LibTorch implementation of SGD}
\usage{
optim_ignite_sgd(
  params,
  lr = optim_required(),
  momentum = 0,
  dampening = 0,
  weight_decay = 0,
  nesterov = FALSE
)
}
\arguments{
\item{params}{(iterable): iterable of parameters to optimize or dicts defining
parameter groups}

\item{lr}{(float): learning rate}

\item{momentum}{(float, optional): momentum factor (default: 0)}

\item{dampening}{(float, optional): dampening for momentum (default: 0)}

\item{weight_decay}{(float, optional): weight decay (L2 penalty) (default: 0)}

\item{nesterov}{(bool, optional): enables Nesterov momentum (default: FALSE)}
}
\description{
Implements stochastic gradient descent (optionally with momentum).
Nesterov momentum is based on the formula from
On the importance of initialization and momentum in deep learning.
}
\section{Fields and Methods}{

See \code{\link{OptimizerIgnite}}.
}

\examples{
if (torch_is_installed()) {
\dontrun{
optimizer <- optim_ignite_sgd(model$parameters(), lr = 0.1)
optimizer$zero_grad()
loss_fn(model(input), target)$backward()
optimizer$step()
}
}
}
