% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_logdet}
\alias{torch_logdet}
\title{Logdet}
\usage{
torch_logdet(self)
}
\arguments{
\item{self}{(Tensor) the input tensor of size \verb{(*, n, n)} where \code{*} is zero or more                batch dimensions.}
}
\description{
Logdet
}
\note{
\preformatted{Result is `-inf` if `input` has zero log determinant, and is `NaN` if
`input` has negative determinant.
}

\preformatted{Backward through `logdet` internally uses SVD results when `input`
is not invertible. In this case, double backward through `logdet` will
be unstable in when `input` doesn't have distinct singular values. See
`~torch.svd` for details.
}
}
\section{logdet(input) -> Tensor }{


Calculates log determinant of a square matrix or batches of square matrices.
}

\examples{
if (torch_is_installed()) {

A = torch_randn(c(3, 3))
torch_det(A)
torch_logdet(A)
A
A$det()
A$det()$log()
}
}
