## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("TORCH_TEST", unset = "0"), "1")
)

## ----setup--------------------------------------------------------------------
#  library(torch)

## -----------------------------------------------------------------------------
#  x <- torch_tensor(1:10)
#  x[1]
#  x[-1]

## -----------------------------------------------------------------------------
#  x <- x$reshape(shape = c(2,5))
#  x
#  x[1,3]
#  x[1,-1]

## ---- error=TRUE--------------------------------------------------------------
#  x[1]

## -----------------------------------------------------------------------------
#  x <- torch_tensor(1:10)
#  x
#  x[2:5]
#  x[1:(-7)]

## -----------------------------------------------------------------------------
#  x[1:5:2]

## -----------------------------------------------------------------------------
#  x[5:N]

## -----------------------------------------------------------------------------
#  x[1:5:2]

## -----------------------------------------------------------------------------
#  x[slc(start = 1, end = 5, step = 2)]

## -----------------------------------------------------------------------------
#  x <- torch_randn(2, 3)
#  x

## -----------------------------------------------------------------------------
#  x[1,]

## -----------------------------------------------------------------------------
#  x[,1:2]

## -----------------------------------------------------------------------------
#  x <- torch_randn(2, 3)
#  x[1,]$shape

## -----------------------------------------------------------------------------
#  x[1,,drop = FALSE]$shape

## -----------------------------------------------------------------------------
#  x <- torch_tensor(c(10))
#  x$shape
#  x[, newaxis]$shape
#  x[, newaxis, newaxis]$shape

## -----------------------------------------------------------------------------
#  x[,NULL]$shape

## -----------------------------------------------------------------------------
#  z <- torch_tensor(1:125)$reshape(c(5,5,5))
#  z[1,..]
#  z[..,1]

## -----------------------------------------------------------------------------
#  x <- torch_randn(4,4)
#  x[c(1,3), c(1,3)]

## -----------------------------------------------------------------------------
#  x[c(TRUE, FALSE, TRUE, FALSE), c(TRUE, FALSE, TRUE, FALSE)]

## -----------------------------------------------------------------------------
#  x <- torch_tensor(rbind(
#    c(1,2,3),
#    c(4,5,6)
#  ))
#  x[x>3]

