% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-flatten.R
\name{nn_unflatten}
\alias{nn_unflatten}
\title{Unflattens a tensor dim expanding it to a desired shape.
For use with [\link{nn_sequential}.}
\usage{
nn_unflatten(dim, unflattened_size)
}
\arguments{
\item{dim}{Dimension to be unflattened}

\item{unflattened_size}{New shape of the unflattened dimension}
}
\description{
Unflattens a tensor dim expanding it to a desired shape.
For use with [\link{nn_sequential}.
}
\examples{
if (torch_is_installed()) {
input <- torch_randn(2, 50)

m <- nn_sequential(
  nn_linear(50, 50),
  nn_unflatten(2, c(2, 5, 5))
)
output <- m(input)
output$size()

}
}
