% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_mel_scale}
\alias{functional_mel_scale}
\title{Mel Scale (functional)}
\usage{
functional_mel_scale(
  specgram,
  n_mels = 128,
  sample_rate = 16000,
  f_min = 0,
  f_max = NULL,
  n_stft = NULL
)
}
\arguments{
\item{specgram}{(Tensor): A spectrogram STFT of dimension (..., freq, time).}

\item{n_mels}{(int, optional): Number of mel filterbanks. (Default: \code{128})}

\item{sample_rate}{(int, optional): Sample rate of audio signal. (Default: \code{16000})}

\item{f_min}{(float, optional): Minimum frequency. (Default: \code{0.})}

\item{f_max}{(float or NULL, optional): Maximum frequency. (Default: \code{sample_rate \%/\% 2})}

\item{n_stft}{(int, optional): Number of bins in STFT. Calculated from first input
if NULL is given.  See \code{n_fft} in :class:\code{Spectrogram}. (Default: \code{NULL})}
}
\value{
\code{tensor}: Mel frequency spectrogram of size (..., \code{n_mels}, time).
}
\description{
Turn a normal STFT into a mel frequency STFT, using a conversion
matrix. This uses triangular filter banks.
}
