% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_random_erasing}
\alias{transform_random_erasing}
\title{Randomly selects a rectangular region in an image and erases its pixel values}
\usage{
transform_random_erasing(
  img,
  p = 0.5,
  scale = c(0.02, 0.33),
  ratio = c(0.3, 3.3),
  value = 0,
  inplace = FALSE
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{p}{probability that the random erasing operation will be performed.}

\item{scale}{range of proportion of erased area against input image.}

\item{ratio}{range of aspect ratio of erased area.}

\item{value}{erasing value. Default is 0. If a single int, it is used to
erase all pixels. If a tuple of length 3, it is used to erase
R, G, B channels respectively.
If a str of 'random', erasing each pixel with random values.}

\item{inplace}{boolean to make this transform inplace. Default set to FALSE.}
}
\description{
'Random Erasing Data Augmentation' by Zhong \emph{et al.}
See \url{https://arxiv.org/pdf/1708.04896}
}
\seealso{
Other transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_color_jitter}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_five_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_random_affine}()},
\code{\link{transform_random_apply}()},
\code{\link{transform_random_choice}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_order}()},
\code{\link{transform_random_perspective}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()},
\code{\link{transform_resize}()},
\code{\link{transform_resized_crop}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_ten_crop}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{transforms}
